<?php

namespace NinjaTables\App\Modules;

class ReadyMadeTable
{
    public function tableByType($table_type)
    {
        $table_types = [
            'pricing_table_one'      => 'pricingTableOne',
            'pricing_table_two'      => 'pricingTableTwo',
            'pricing_table_three'    => 'pricingTableThree',
            'pricing_table_four'     => 'pricingTableFour',
            'comparison_table_one'   => 'comparisonTableOne',
            'comparison_table_two'   => 'comparisonTableTwo',
            'comparison_table_three' => 'comparisonTableThree',
            'comparison_table_four'  => 'comparisonTableFour',
            'comparison_table_five'  => 'comparisonTableFive',
            'employee_table_one'     => 'employeeTableOne',
            'employee_table_two'     => 'employeeTableTwo',
            'employee_table_three'   => 'employeeTableThree',
            'schedule_table_one'     => 'scheduleTableOne',
            'schedule_table_two'     => 'scheduleTableTwo',
            'schedule_table_three'   => 'scheduleTableThree',
        ];

        if (in_array($table_type, array_keys($table_types))) {
            $method = $table_types[$table_type];

            return $this->$method();
        }
    }

    public function pricingTableOne()
    {
        $table_data       = '{ "id": 516, "table_name": "Pricing Table 4", "data": [ { "rows": { "column_0": { "style": { "tdId": 14590, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 882427, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "BASIC", "style": { "fontSize": 20, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 31573, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 322413, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "STANDARD", "style": { "fontSize": 20, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 92295, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 178459, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "PREMIUM", "style": { "fontSize": 20, "color": "rgb(242, 242, 242)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 1908, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 89837, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 540108, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "4.99$/per month", "style": { "fontSize": 25, "color": "rgb(231, 231, 231)", "alignment": "center", "margin": { "top": 18, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } }, { "id": "192259", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "with 4 days free trail", "style": { "fontSize": 12, "color": "#DDDDDD", "alignment": "center", "margin": { "top": 2, "bottom": 18, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 77888, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "912121", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "9.99$/per month", "style": { "fontSize": 25, "color": "rgb(231, 231, 231)", "alignment": "center", "margin": { "top": 18, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } }, { "id": "597515", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "with 4 days free trail", "style": { "fontSize": 12, "color": "#DDDDDD", "alignment": "center", "margin": { "top": 2, "bottom": 18, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 69208, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "512259", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "19.99$/per month", "style": { "fontSize": 25, "color": "rgb(231, 231, 231)", "alignment": "center", "margin": { "top": 18, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } }, { "id": "323582", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "with 4 days free trail", "style": { "fontSize": 12, "color": "#DDDDDD", "alignment": "center", "margin": { "top": 2, "bottom": 18, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 6548, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 31034, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "955152", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "1 GB Disk Space", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 19907, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "652996", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "1 GB Disk Space", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 88377, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 858819, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "1 GB Disk Space", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 9768, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 73888, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 726358, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "500 MB Bandwidth", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 70415, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 207958, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "2 GB Bandwidth", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 60054, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 886960, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5 GB Bandwidth", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 5653, "backgroundColor": "", "rowHeight": 50 } }, { "style": { "trId": "626", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "5882", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "165298", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "1 Sub Domain", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "1096", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "156898", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "3 Sub Domain", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "5112", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "168248", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "10 Sub Domain", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "115", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "5515", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "110111", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "1 Email Account", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "6566", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "152155", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5 Email Account", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "5591", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "605660", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "10 Email Account", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "502", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "6262", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "966516", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "SMTP", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "5165", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "446626", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "SMTP", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "5626", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "565969", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "SMTP", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "851", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "0316", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "621622", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Monthly Traffic: 1000 GB", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "1316", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "328662", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Monthly Traffic: 2000 GB", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "2832", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "861651", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Monthly Traffic: 3000 GB", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "160", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "5226", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "868688", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Network Port: 50 Mbps", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "8828", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "665032", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Network Port: 75 Mbps", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "1866", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "505638", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Network Port: 100 Mbps", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } } ], "headers": [ "column_0", "column_1", "column_2" ], "table": { "tr": 9, "tc": "3", "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": false, "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": 3, "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": 3, "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": "false", "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": "700", "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 150, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "#2F2B2B" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#454343" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "rgb(69, 67, 67)" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": false, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 0, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#000000" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": "true", "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": "true" }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "#000000" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 1, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000000" }, "font_family": { "label": "Font Family", "type": "select", "value": "Georgia", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": "false", "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": "true" } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": "false", "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": "1", "max": "5" } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": "1", "max": "5" } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "false", "disable": "true" }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": "false", "disable": "true" } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function pricingTableTwo()
    {
        $table_data       = '{ "id": 569, "table_name": "Pricing Table 2", "data": [ { "rows": { "column_0": { "style": { "tdId": 42990, "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "69105", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "options-outline", "style": { "color": "#FBFBFB", "fontSize": 45, "alignment": "center", "margin": { "top": 5, "bottom": 5, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": 265381, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "VPS-01", "style": { "fontSize": 16, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 5, "bottom": 15, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } }, { "id": "821512", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$10.01/ month", "style": { "fontSize": 21, "color": "#F2F2F2", "alignment": "center", "margin": { "top": 0, "bottom": 15, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 79463, "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "673253", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "grid-outline", "style": { "color": "#FBFBFB", "fontSize": 45, "alignment": "center", "margin": { "top": 5, "bottom": 5, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "49119", "data": { "name": "Ribbon", "type": "ribbon", "icon": "el-icon-collection-tag", "has_pro": true, "value": "Popular", "style": { "ribbonType": "bookmark", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "color": "rgb(250, 250, 255)", "fontSize": 15, "backgroundColor": "#D77202", "width": 230, "height": 10, "bookmarkHeight": 37, "bookmarkWidth": 72, "sideHeight": 17, "sideWidth": 55, "xAxis": 164, "yAxis": -65, "textXAxis": 0, "textYAxis": 0, "fontWeight": [ "bold" ] } } }, { "id": "207291", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "VPS-02", "style": { "fontSize": 16, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 5, "bottom": 15, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } }, { "id": "062122", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$20.01/ month", "style": { "fontSize": 21, "color": "#F2F2F2", "alignment": "center", "margin": { "top": 0, "bottom": 15, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 77648, "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "633864", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "logo-google-playstore", "style": { "color": "#FBFBFB", "fontSize": 45, "alignment": "center", "margin": { "top": 5, "bottom": 5, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "892899", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "VPS-03", "style": { "fontSize": 16, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 5, "bottom": 15, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } }, { "id": "87121", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$30.01/ month", "style": { "fontSize": 21, "color": "#F2F2F2", "alignment": "center", "margin": { "top": 0, "bottom": 15, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 6351, "backgroundColor": "", "rowHeight": 50 } }, { "style": { "trId": "141", "backgroundColor": "", "rowHeight": 55 }, "rows": { "column_0": { "style": { "tdId": "5028", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "514386", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "RAM Guaranteed: 5 GB", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "8640", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "162211", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "RAM Guaranteed: 1 GB", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "0383", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "628518", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "RAM Guaranteed: 1.5 GB", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "815", "backgroundColor": "", "rowHeight": 55 }, "rows": { "column_0": { "style": { "tdId": "7622", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "523333", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "RAM Burstable: 1 GB", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "4912", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "693142", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "RAM Burstable: 2 GB", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "7795", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "422466", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "RAM Burstable: 3 GB", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "086", "backgroundColor": "", "rowHeight": 55 }, "rows": { "column_0": { "style": { "tdId": "4204", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "661862", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "CPU Cores: 1 ", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "6603", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "602160", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "CPU Cores: 2 ", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "3046", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "080066", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "CPU Cores: 3", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "844", "backgroundColor": "", "rowHeight": 55 }, "rows": { "column_0": { "style": { "tdId": "0688", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "180404", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Total CPU Power: 1.23 GHz", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "1058", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "118108", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Total CPU Power: 2.46 GHz", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "2530", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "080085", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Total CPU Power: 3.69 GHz", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "001", "backgroundColor": "", "rowHeight": 55 }, "rows": { "column_0": { "style": { "tdId": "0900", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "214939", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Disk Space: 25 GB", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "1318", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "091339", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Disk Space: 50 GB", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "2814", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "231814", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Disk Space: 75 GB", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "440", "backgroundColor": "", "rowHeight": 55 }, "rows": { "column_0": { "style": { "tdId": "8102", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "721562", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Monthly Traffic: 1000 GB", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "6107", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "027101", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Monthly Traffic: 2000 GB", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "2854", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "250507", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Monthly Traffic: 3000 GB", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "445", "backgroundColor": "", "rowHeight": 55 }, "rows": { "column_0": { "style": { "tdId": "8244", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "008464", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Network Port: 100 Mbps", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "4022", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "310488", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Network Port: 100 Mbps", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "4100", "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "445644", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Network Port: 100 Mbps", "style": { "fontSize": 14, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "rows": { "column_0": { "style": { "tdId": 76308, "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "952242", "data": { "name": "Button", "type": "button", "icon": "el-icon-bank-card", "has_pro": false, "value": "Buy Now", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "backgroundColor": "#379D13", "borderColor": "#000000", "borderSize": 0, "borderRadius": 5, "isHover": false, "hoverColor": "#000000", "hoverBackgroundColor": "#1E90FF", "hoverBorderColor": "#000000", "hoverBorderSize": "", "hoverIconColor": "#000000", "transition": 1, "fullWidth": false, "url": "https://example.com", "newTab": true, "contentAlignment": "center", "alignment": "center", "fontWeight": [ "bold" ], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 3, "bottom": 3, "left": 10, "right": 10 }, "enableIcon": false, "iconColor": "#000000", "iconFontSize": 15, "iconName": "albums", "iconPosition": "left", "itemSpacing": 0 } } } ] }, "column_1": { "style": { "tdId": 35288, "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "20024", "data": { "name": "Button", "type": "button", "icon": "el-icon-bank-card", "has_pro": false, "value": "Buy Now", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "backgroundColor": "#379D13", "borderColor": "#000000", "borderSize": 0, "borderRadius": 5, "isHover": false, "hoverColor": "#000000", "hoverBackgroundColor": "#1E90FF", "hoverBorderColor": "#000000", "hoverBorderSize": "", "hoverIconColor": "#000000", "transition": 1, "fullWidth": false, "url": "https://example.com", "newTab": true, "contentAlignment": "center", "alignment": "center", "fontWeight": [ "bold" ], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 3, "bottom": 3, "left": 10, "right": 10 }, "enableIcon": false, "iconColor": "#000000", "iconFontSize": 15, "iconName": "albums", "iconPosition": "left", "itemSpacing": 0 } } } ] }, "column_2": { "style": { "tdId": 23093, "backgroundColor": "", "columnWidth": 230, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "522212", "data": { "name": "Button", "type": "button", "icon": "el-icon-bank-card", "has_pro": false, "value": "Buy Now", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "backgroundColor": "#379D13", "borderColor": "#000000", "borderSize": 0, "borderRadius": 5, "isHover": false, "hoverColor": "#000000", "hoverBackgroundColor": "#1E90FF", "hoverBorderColor": "#000000", "hoverBorderSize": "", "hoverIconColor": "#000000", "transition": 1, "fullWidth": false, "url": "https://example.com", "newTab": true, "contentAlignment": "center", "alignment": "center", "fontWeight": [ "bold" ], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 3, "bottom": 3, "left": 10, "right": 10 }, "enableIcon": false, "iconColor": "#000000", "iconFontSize": 15, "iconName": "albums", "iconPosition": "left", "itemSpacing": 0 } } } ] } }, "style": { "trId": 5299, "backgroundColor": "", "rowHeight": 55 } } ], "headers": [ "column_0", "column_1", "column_2" ], "table": { "tr": 9, "tc": "3", "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": true, "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": 10, "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": 1, "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": "false", "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": "700", "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 150, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "#255C8E" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#C4CED0" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "#DDDDDD" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": false, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 0, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#FFFFFF" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": false, "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": "true" }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "#000000" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 1, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "" }, "font_family": { "label": "Font Family", "type": "select", "value": "Helvetica", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": "true" } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": false }, "cell_direction": { "label": "Cell Stack Direction", "type": "select", "value": "column", "items": [ { "label": "Row", "value": "row" }, { "label": "Column", "value": "column" } ] }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "mobile_cell_border", "type": "slider", "value": 5, "min": 1, "max": 10 } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": false }, "cell_direction": { "label": "Cell Stack Direction", "type": "select", "value": "column", "items": [ { "label": "Row", "value": "row" }, { "label": "Column", "value": "column" } ] }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 3, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "tablet_cell_border", "type": "slider", "value": 5, "min": 1, "max": 10 } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false, "disable": true }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": false, "disable": true } } } } }, "responsive_settings": { "name": "Responsive Settings", "key": "responsive_settings", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "mobile_cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "mobile_table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" } }, "tablet": { "name": "Tablet", "key": "tablet", "tablet_cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "tablet_table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function pricingTableThree()
    {
        $table_data       = '{ "id": 1000, "table_name": "Pricing Table 3", "data": [ { "rows": { "column_0": { "style": { "tdId": 19439774, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "080970696", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "help-buoy", "style": { "color": "rgb(254, 254, 254)", "fontSize": 75, "alignment": "center", "margin": { "top": 10, "bottom": 10, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "324291043", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "STARTUP", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } }, { "id": "361936912", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Perfect For Small Business", "style": { "fontSize": 14, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 7, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "italic" ] } } } ] }, "column_1": { "style": { "tdId": 15668791, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "020229909", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "copy", "style": { "color": "rgb(254, 254, 254)", "fontSize": 75, "alignment": "center", "margin": { "top": 10, "bottom": 10, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "296962662", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "ENTERPRICE", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } }, { "id": "530539632", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Perfect For Small Business", "style": { "fontSize": 14, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 7, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "italic" ] } } } ] }, "column_2": { "style": { "tdId": 87991884, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "961962912", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "aperture", "style": { "color": "rgb(254, 254, 254)", "fontSize": 75, "alignment": "center", "margin": { "top": 10, "bottom": 10, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "264322614", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "SUPER", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } }, { "id": "633003921", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Perfect For Small Business", "style": { "fontSize": 14, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 7, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "italic" ] } } } ] } }, "style": { "trId": 4368420, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 86189863, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "070023906", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "100 GB of Space", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 5, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "969659962", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "Support at $25/hr", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "669691310", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "Disk Space: 25 GB", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "788636009", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "Free SSL/TLS Certificate", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "033166663", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "Network Port: 50 Mbps", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "943006643", "data": { "name": "Button", "type": "button", "icon": "el-icon-bank-card", "has_pro": false, "value": "SIGN UP", "style": { "fontSize": 10, "color": "#FFFFFF", "backgroundColor": "#379D13", "borderColor": "", "borderSize": 0, "borderRadius": 27, "isHover": false, "hoverColor": "", "hoverBackgroundColor": "#1E90FF", "hoverBorderColor": "#000000", "hoverBorderSize": "", "hoverIconColor": "", "transition": 1, "fullWidth": false, "url": "https://wpmanageninja.com/downloads/ninja-tables-pro-add-on/", "newTab": true, "contentAlignment": "center", "alignment": "center", "fontWeight": [ "bold" ], "margin": { "top": 20, "bottom": 5, "left": 0, "right": 0 }, "padding": { "top": 5, "bottom": 5, "left": 30, "right": 30 }, "enableIcon": false, "iconColor": "", "iconFontSize": "", "iconName": "ninja-table", "iconPosition": "left", "itemSpacing": 0 } } } ] }, "column_1": { "style": { "tdId": 79212167, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "551141961", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "200 GB of Space", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 5, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "639944662", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "Support at $20/hr", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "195979600", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "Disk Space: 50 GB", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 5, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "996300999", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "Free SSL/TLS Certificate", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 5, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "162136967", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "Network Port: 75 Mbps", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 5, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "663636060", "data": { "name": "Button", "type": "button", "icon": "el-icon-bank-card", "has_pro": false, "value": "SIGN UP", "style": { "fontSize": 10, "color": "#FFFFFF", "backgroundColor": "#379D13", "borderColor": "", "borderSize": 0, "borderRadius": 27, "isHover": false, "hoverColor": "", "hoverBackgroundColor": "#1E90FF", "hoverBorderColor": "#000000", "hoverBorderSize": "", "hoverIconColor": "", "transition": 1, "fullWidth": false, "url": "https://wpmanageninja.com/downloads/ninja-tables-pro-add-on/", "newTab": true, "contentAlignment": "center", "alignment": "center", "fontWeight": [ "bold" ], "margin": { "top": 20, "bottom": 5, "left": 0, "right": 0 }, "padding": { "top": 5, "bottom": 5, "left": 30, "right": 30 }, "enableIcon": false, "iconColor": "", "iconFontSize": "", "iconName": "ninja-table", "iconPosition": "left", "itemSpacing": 0 } } } ] }, "column_2": { "style": { "tdId": 33975659, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "594164445", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "300 GB of Space", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 5, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "599998133", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "Support at $15/hr", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "099671796", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "Disk Space: 75 GB", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 5, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "996111999", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "Free SSL/TLS Certificate", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 5, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "159122269", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": true, "value": "Network Port: 100 Mbps", "style": { "iconColor": "#379D13", "iconFontSize": 18, "iconName": "arrow-forward-circle", "iconPosition": "left", "itemSpacing": 0, "color": "", "fontSize": 10, "alignment": "left", "fontWeight": [], "margin": { "top": 5, "bottom": 3, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } }, { "id": "330300016", "data": { "name": "Button", "type": "button", "icon": "el-icon-bank-card", "has_pro": false, "value": "SIGN UP", "style": { "fontSize": 10, "color": "#FFFFFF", "backgroundColor": "#379D13", "borderColor": "", "borderSize": 0, "borderRadius": 27, "isHover": false, "hoverColor": "", "hoverBackgroundColor": "#1E90FF", "hoverBorderColor": "#000000", "hoverBorderSize": "", "hoverIconColor": "", "transition": 1, "fullWidth": false, "url": "https://wpmanageninja.com/downloads/ninja-tables-pro-add-on/", "newTab": true, "contentAlignment": "center", "alignment": "center", "fontWeight": [ "bold" ], "margin": { "top": 20, "bottom": 5, "left": 0, "right": 0 }, "padding": { "top": 5, "bottom": 5, "left": 30, "right": 30 }, "enableIcon": false, "iconColor": "", "iconFontSize": "", "iconName": "ninja-table", "iconPosition": "left", "itemSpacing": 0 } } } ] } }, "style": { "trId": 7112697, "backgroundColor": "", "rowHeight": "" } } ], "headers": [ "column_0", "column_1", "column_2" ], "table": { "tr": "2", "tc": "3", "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": false, "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": 3, "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": 3, "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": false, "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": 700, "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 150, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "#253148" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#dddddd" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "#ffffff" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": true, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 0, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#000000" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": true, "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": true }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "#000000" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 1, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "margin_bottom": { "label": "Margin Bottom", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000001" }, "font_family": { "label": "Font Family", "type": "select", "value": "inherit", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": true } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": false }, "cell_direction": { "label": "Cell Stack Direction", "type": "select", "value": "row", "items": [ { "label": "Row", "value": "row" }, { "label": "Column", "value": "column" } ] }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": true }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "mobile_cell_border", "type": "slider", "value": 5, "min": 1, "max": 10 } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": false }, "cell_direction": { "label": "Cell Stack Direction", "type": "select", "value": "row", "items": [ { "label": "Row", "value": "row" }, { "label": "Column", "value": "column" } ] }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": true }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "tablet_cell_border", "type": "slider", "value": 5, "min": 1, "max": 10 } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false, "disable": true }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": false, "disable": true } } } } }, "responsive_settings": { "name": "Responsive Settings", "key": "responsive_settings", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "mobile_cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "mobile_table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" } }, "tablet": { "name": "Tablet", "key": "tablet", "tablet_cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "tablet_table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function pricingTableFour()
    {

        $table_data       = '{ "id": 617, "table_name": "Pricing Table 1", "data": [ { "rows": { "column_0": { "style": { "tdId": 93237, "backgroundColor": "#2B659A", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 811833, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "DELUXE", "style": { "fontSize": 25, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } }, { "id": "67787", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "For Large Business", "style": { "fontSize": 15, "color": "#DDDDDD", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": "7472", "backgroundColor": "#B53887", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "815650771", "data": { "name": "Ribbon", "type": "ribbon", "icon": "el-icon-collection-tag", "has_pro": true, "value": "Popular", "style": { "ribbonType": "corner", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "ribbonPosition": "left", "color": "#DDDDDD", "fontSize": 10, "backgroundColor": "#5C4DA2", "width": 245, "height": 10, "bookmarkHeight": 36, "bookmarkWidth": 55, "sideHeight": 17, "sideWidth": 55, "horizontalWidth": 170, "horizontalHeight": 25, "xAxis": -10, "yAxis": -52, "cornerXAxis": -13, "horizontalXAxis": -10, "textXAxis": 24, "textYAxis": -6, "fontWeight": [ "bold" ] } } }, { "id": "177128", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "STANDARD", "style": { "fontSize": 25, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } }, { "id": "477017", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "For Small Business", "style": { "fontSize": 15, "color": "#DDDDDD", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": "8383", "backgroundColor": "#DD4E16", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "638906", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "FREE", "style": { "fontSize": 25, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } }, { "id": "799988", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "For Regular Business", "style": { "fontSize": 15, "color": "#DDDDDD", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 6383, "backgroundColor": "", "rowHeight": 150 } }, { "rows": { "column_0": { "style": { "tdId": 69443, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "801241", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$99/ month", "style": { "fontSize": 18, "color": "#2B659A", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "italic", "bold" ] } } } ] }, "column_3": { "style": { "tdId": "8577", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "668078", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$59/ month", "style": { "fontSize": 18, "color": "#C71585", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "italic", "bold" ] } } } ] }, "column_4": { "style": { "tdId": "0441", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "505588", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$00/ month", "style": { "fontSize": 18, "color": "rgb(221, 78, 22)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "italic", "bold" ] } } } ] } }, "style": { "trId": 4336, "backgroundColor": "", "rowHeight": 50 } }, { "style": { "trId": "280", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_4": { "style": { "tdId": "4200", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "020022", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Unlimited Pages", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": "4004", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "881198", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Unlimited Pages", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_0": { "style": { "tdId": "0211", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "018812", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Unlimited Pages", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "style": { "trId": "861", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_4": { "style": { "tdId": "2622", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "244240", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "All Templates & Blocks", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": "2200", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "348286", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "All Templates & Blocks", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_0": { "style": { "tdId": "2243", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "104461", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "All Templates & Blocks", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "style": { "trId": "110", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_4": { "style": { "tdId": "8335", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "880340", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Contact & Subscribe Forms", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": "4804", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "333411", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Contact & Subscribe Forms", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_0": { "style": { "tdId": "0151", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "583536", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Contact & Subscribe Forms", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "style": { "trId": "646", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_4": { "style": { "tdId": "8488", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "246042", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Free SSL/TLS Certificate", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": "8104", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "866244", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Free SSL/TLS Certificate", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_0": { "style": { "tdId": "6285", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "644486", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Free SSL/TLS Certificate", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "style": { "trId": "668", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_4": { "style": { "tdId": "0236", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "289430", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Remove Branding", "style": { "iconColor": "#FF4500", "iconFontSize": 20, "iconName": "close-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": "9411", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "831079", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Remove Branding", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_0": { "style": { "tdId": "0860", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "839701", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Remove Branding", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "style": { "trId": "946", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_4": { "style": { "tdId": "7193", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "623006", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Custom Form", "style": { "iconColor": "#FF4500", "iconFontSize": 20, "iconName": "close-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": "0946", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "943394", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Custom Form", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_0": { "style": { "tdId": "1912", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "439901", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Custom Form", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "style": { "trId": "188", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_4": { "style": { "tdId": "1486", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "197844", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Payment Integration", "style": { "iconColor": "#FF4500", "iconFontSize": 20, "iconName": "close-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": "4182", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "866971", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Payment Integration", "style": { "iconColor": "#FF4500", "iconFontSize": 20, "iconName": "close-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_0": { "style": { "tdId": "7198", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "897077", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Payment Integration", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "style": { "trId": "878", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_4": { "style": { "tdId": "6881", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "287053", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Export HTML/CSS/JS", "style": { "iconColor": "#FF4500", "iconFontSize": 20, "iconName": "close-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": "7417", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "088858", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Export HTML/CSS/JS", "style": { "iconColor": "#FF4500", "iconFontSize": 20, "iconName": "close-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_0": { "style": { "tdId": "3080", "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "710848", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Export HTML/CSS/JS", "style": { "iconColor": "#379D13", "iconFontSize": 20, "iconName": "checkmark-circle", "iconPosition": "left", "itemSpacing": 0, "color": "#000000", "fontSize": 15, "alignment": "left", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } } ], "headers": [ "column_3", "column_4", "column_0" ], "table": { "tr": 10, "tc": 3, "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": "false", "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": "3", "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": "3", "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": "false", "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": "700", "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 150, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "#dddddd" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#F8F1F1" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "#ffffff" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": false, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 2, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#DDDDDD" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": "true", "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": "true" }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "#DDDDDD" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 3, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000000" }, "font_family": { "label": "Font Family", "type": "select", "value": "Georgia", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": "false", "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": "true" } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": "false", "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": "1", "max": "5" } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": false }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 3, "min": "1", "max": "5" } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "false", "disable": "true" }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": "false", "disable": "true" } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function comparisonTableOne()
    {
        $table_data       = '{ "id": 377, "table_name": "Comparison Table One", "data": [ { "rows": { "column_0": { "style": { "tdId": 57040742, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "889116996", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Product 1", "style": { "fontSize": 20, "color": "", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 79150363, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "843161432", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Product 2", "style": { "fontSize": 20, "color": "", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 81053895, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "977616873", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Product 3", "style": { "fontSize": 20, "color": "", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 3728078, "backgroundColor": "", "rowHeight": 60 } }, { "rows": { "column_0": { "style": { "tdId": 45114895, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "867400610", "data": { "name": "List", "type": "list", "icon": "el-icon-s-operation", "has_pro": false, "value": [ "Feature 1", "Feature 2", "Feature 3", "Feature 4" ], "style": { "listType": "ul", "color": "", "fontSize": 10, "alignment": "center", "fontWeight": [], "lineHeight": 20, "listStyle": "disc", "itemSpacing": 0, "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_1": { "style": { "tdId": 87578018, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "067768603", "data": { "name": "List", "type": "list", "icon": "el-icon-s-operation", "has_pro": false, "value": [ "Feature 1", "Feature 2", "Feature 3", "Feature 4" ], "style": { "listType": "ul", "color": "", "fontSize": 10, "alignment": "center", "fontWeight": [], "lineHeight": 20, "listStyle": "disc", "itemSpacing": 0, "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": 90023273, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "880380886", "data": { "name": "List", "type": "list", "icon": "el-icon-s-operation", "has_pro": false, "value": [ "Feature 1", "Feature 2", "Feature 3", "Feature 4" ], "style": { "listType": "ul", "color": "", "fontSize": 10, "alignment": "center", "fontWeight": [], "lineHeight": 20, "listStyle": "disc", "itemSpacing": 0, "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 5116582, "backgroundColor": "", "rowHeight": 134 } }, { "rows": { "column_0": { "style": { "tdId": 74161411, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "896911878", "data": { "name": "Rating", "type": "star_rating", "icon": "el-icon-star-off", "has_pro": false, "value": 3, "style": { "color": "#F2C009", "ratingSize": 28, "maxStar": 5, "alignment": "center", "showRatingValue": false, "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_1": { "style": { "tdId": 47043917, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "139703797", "data": { "name": "Rating", "type": "star_rating", "icon": "el-icon-star-off", "has_pro": false, "value": 4.5, "style": { "color": "#F2C009", "ratingSize": 28, "maxStar": 5, "alignment": "center", "showRatingValue": false, "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": 55195801, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "796897173", "data": { "name": "Rating", "type": "star_rating", "icon": "el-icon-star-off", "has_pro": false, "value": 3.5, "style": { "color": "#F2C009", "ratingSize": 28, "maxStar": 5, "alignment": "center", "showRatingValue": false, "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 9676948, "backgroundColor": "", "rowHeight": 65 } }, { "rows": { "column_0": { "style": { "tdId": 27693401, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "333934239", "data": { "name": "Button", "type": "button", "icon": "el-icon-bank-card", "has_pro": false, "value": "Check out", "style": { "fontSize": 16, "color": "rgb(255, 255, 255)", "buttonSize": "L", "backgroundColor": "rgb(9, 186, 82)", "borderColor": "#1E90FF", "borderSize": 1, "borderRadius": 29, "isHover": false, "hoverColor": "", "hoverBackgroundColor": "#1E90FF", "hoverBorderColor": "#000000", "hoverBorderSize": 0, "hoverIconColor": "", "transition": 1, "fullWidth": false, "url": "https://example.com", "newTab": true, "linkAttributes": [], "contentAlignment": "center", "alignment": "center", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "enableIcon": false, "iconColor": "", "iconFontSize": 10, "iconName": "ninja-table", "iconPosition": "left", "itemSpacing": 0 } } } ] }, "column_1": { "style": { "tdId": 55792647, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "411758479", "data": { "name": "Button", "type": "button", "icon": "el-icon-bank-card", "has_pro": false, "value": "Check out", "style": { "fontSize": 16, "color": "rgb(255, 255, 255)", "buttonSize": "L", "backgroundColor": "rgb(9, 186, 82)", "borderColor": "#1E90FF", "borderSize": 1, "borderRadius": 29, "isHover": false, "hoverColor": "", "hoverBackgroundColor": "#1E90FF", "hoverBorderColor": "#000000", "hoverBorderSize": 0, "hoverIconColor": "", "transition": 1, "fullWidth": false, "url": "https://example.com", "newTab": true, "linkAttributes": [], "contentAlignment": "center", "alignment": "center", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "enableIcon": false, "iconColor": "", "iconFontSize": 10, "iconName": "ninja-table", "iconPosition": "left", "itemSpacing": 0 } } } ] }, "column_2": { "style": { "tdId": 67844298, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "901177848", "data": { "name": "Button", "type": "button", "icon": "el-icon-bank-card", "has_pro": false, "value": "Check out", "style": { "fontSize": 16, "color": "rgb(255, 255, 255)", "buttonSize": "L", "backgroundColor": "rgb(9, 186, 82)", "borderColor": "#1E90FF", "borderSize": 1, "borderRadius": 29, "isHover": false, "hoverColor": "", "hoverBackgroundColor": "#1E90FF", "hoverBorderColor": "#000000", "hoverBorderSize": 0, "hoverIconColor": "", "transition": 1, "fullWidth": false, "url": "https://example.com", "newTab": true, "linkAttributes": [], "contentAlignment": "center", "alignment": "center", "fontWeight": [], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "enableIcon": false, "iconColor": "", "iconFontSize": 10, "iconName": "ninja-table", "iconPosition": "left", "itemSpacing": 0 } } } ] } }, "style": { "trId": 2238720, "backgroundColor": "", "rowHeight": 70 } } ], "headers": [ "column_0", "column_1", "column_2" ], "table": { "tr": "4", "tc": "3", "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": true, "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": 9, "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": 0, "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": false, "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": 700, "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 150, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 10000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "rgb(214, 224, 249)" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#E0F2F9" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "#F3F8F3" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": true, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 0, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#000000" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": true, "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": true }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "#000000" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 0, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "margin_bottom": { "label": "Margin Bottom", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000001" }, "font_family": { "label": "Font Family", "type": "select", "value": "inherit", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": true } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": false }, "cell_direction": { "label": "Cell Stack Direction", "type": "select", "value": "column", "items": [ { "label": "Row", "value": "row" }, { "label": "Column", "value": "column" } ] }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "mobile_cell_border", "type": "slider", "value": 5, "min": 1, "max": 10 } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": false }, "cell_direction": { "label": "Cell Stack Direction", "type": "select", "value": "column", "items": [ { "label": "Row", "value": "row" }, { "label": "Column", "value": "column" } ] }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 2, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "tablet_cell_border", "type": "slider", "value": 5, "min": 1, "max": 10 } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false, "disable": true }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": false, "disable": true } } } } }, "responsive_settings": { "name": "Responsive Settings", "key": "responsive_settings", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "mobile_cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "mobile_table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" } }, "tablet": { "name": "Tablet", "key": "tablet", "tablet_cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "tablet_table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function comparisonTableTwo()
    {

        $table_data       = '{ "id": 357, "table_name": "Comparison Table 2", "data": [ { "style": { "trId": "028", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "2181", "backgroundColor": "#DDDDDD", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "688633", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Comparison", "style": { "fontSize": 16, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "9661", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "616283", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "iPhone 13", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "6683", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "183019", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "iPhone12", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "rows": { "column_0": { "style": { "tdId": 60893, "backgroundColor": "#DDDDDD", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "694011", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Preview", "style": { "fontSize": 16, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 41229, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "19841", "data": { "name": "Image", "type": "image", "icon": "el-icon-picture-outline", "has_pro": false, "value": "https://convert.test/wp-content/plugins/ninja-tables/assets/img/iphone-12-pro-max.jpg", "style": { "alignment": "center", "size": 60, "shape": "square", "alt": "Demo Image", "link": "https://www.example.com/", "target": "blank", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": 17191, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "981561", "data": { "name": "Image", "type": "image", "icon": "el-icon-picture-outline", "has_pro": false, "value": "https://convert.test/wp-content/plugins/ninja-tables/assets/img/iphone-12-normal.jpg", "style": { "alignment": "center", "size": 60, "shape": "square", "alt": "Demo Image", "link": "https://www.example.com/", "target": "blank", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 9652, "backgroundColor": "", "rowHeight": 50 } }, { "style": { "trId": "111", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "6413", "backgroundColor": "#DDDDDD", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "666026", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Announced", "style": { "fontSize": 16, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "1691", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "194498", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "2022, February 09", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "3494", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "181404", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "2021, September 13", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "041", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "8181", "backgroundColor": "#DDDDDD", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "151114", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Status", "style": { "fontSize": 16, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "5505", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "885141", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Available. Released 2022, February 24", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "0848", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "464115", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Available. Released 2021, September 25", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "541", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "1295", "backgroundColor": "#DDDDDD", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "205148", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Size", "style": { "fontSize": 16, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "9005", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "191251", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "6.1 inches", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "4110", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "189160", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "6.1 inches", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "626", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "6111", "backgroundColor": "#DDDDDD", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "444121", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Weight", "style": { "fontSize": 16, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "6486", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "668441", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "6.14 ounces", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "1781", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "624166", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5.78 ounces", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "218", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "6116", "backgroundColor": "#DDDDDD", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "216742", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Processor", "style": { "fontSize": 16, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "1872", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "711888", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "A15", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "1814", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "171771", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "A14", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "416", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "1849", "backgroundColor": "#DDDDDD", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "412850", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Chipset", "style": { "fontSize": 16, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "9116", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "151611", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Apple A15 Bionic (5 nm)", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "8819", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "112111", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Exynos 2200 (4 nm) - Europe", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "010", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "9441", "backgroundColor": "#DDDDDD", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "141111", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Camera", "style": { "fontSize": 16, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "9411", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "411114", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "12 MP, f/1.6, 26mm (wide), 1.7µm, dual pixel PDAF, sensor-shift OIS", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "1990", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "189134", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "12 MP, f/1.6, 26mm (wide), 1.7µm, dual pixel PDAF, sensor-shift OIS", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "999", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "6161", "backgroundColor": "#DDDDDD", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "114099", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Battery", "style": { "fontSize": 16, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "1161", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "431111", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Li-Ion 3240 mAh, non-removable", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "8974", "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "111410", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Li-Ion 3000 mAh, non-removable", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "rows": { "column_0": { "style": { "tdId": 26637, "backgroundColor": "#DDDDDD", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 615626, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Resolution", "style": { "fontSize": 16, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 85483, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 645282, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "2532x1170", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 11183, "backgroundColor": "", "columnWidth": 250, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "has_pro": true, "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 344302, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "2532x1170", "style": { "fontSize": 14, "color": "#474778", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 5259, "backgroundColor": "", "rowHeight": 50 } } ], "headers": [ "column_0", "column_1", "column_2" ], "table": { "tr": 11, "tc": "3", "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": "false", "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": "3", "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": "3", "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": "false", "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": "700", "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 150, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "#dddddd" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#F2F2F2" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "#ffffff" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": false, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 0, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#000000" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": "true", "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": "true" }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "#000000" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 1, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000000" }, "font_family": { "label": "Font Family", "type": "select", "value": "inherit", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": "false", "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": "true" } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": "false", "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": false }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 2, "min": "1", "max": "5" } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": "1", "max": "5" } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "false", "disable": "true" }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": "false", "disable": "true" } } } } } }';

        $table_data = $this->replaceLink('https://convert.test', $table_data);


        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function comparisonTableThree()
    {
        $table_data       = '{ "id": 984, "table_name": "Comparison Table 3", "data": [ { "rows": { "column_0": { "style": { "tdId": 44791045, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 465444949, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Features", "style": { "fontSize": 32, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 14215516, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 209814464, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "WP Social Ninja", "style": { "fontSize": 17, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 22273013, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "683936926", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Smash Balloon", "style": { "fontSize": 17, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": 91995191, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "020324413", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "SpotlightWP", "style": { "fontSize": 17, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": 44222149, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "122613467", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "elfsight", "style": { "fontSize": 17, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 6792389, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 11653581, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "366639711", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Price", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 30060922, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "326321163", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$79 Annually", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 30807705, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "373271606", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$98 Annually", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 13755673, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "334833333", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$49 Annually", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": 89015207, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "669565663", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$180 Annually", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 3210240, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 56774203, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 682317574, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Multiple Social Platforms", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 52004592, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "216312162", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "29+", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 46177630, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "323296636", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "4", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 70921635, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "316218691", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "1", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": 59665151, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "230638001", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "33", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 8758503, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 89615376, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "571222297", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Multiple Posts Order", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 43797864, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "965954326", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5 Types", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 77984048, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "022666662", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "2 Types", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 31045995, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "129372266", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5 Types", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": 20639210, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "926310209", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "2 Types", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 8833775, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 52826234, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "626619139", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Create Multiple Templates", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 78834876, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "169323466", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": 24571023, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "232666935", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": 42836553, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "692513293", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_4": { "style": { "tdId": 63024955, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "666321279", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 7798828, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 99084020, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "306669216", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Search Engine Accessible", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 93548716, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "364946489", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": 29930326, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "619315961", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": 86650548, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "560952555", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#FF4500", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_4": { "style": { "tdId": 55245266, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "663293633", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#FF4500", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 9976233, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 52277336, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 5, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 966707313, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Number of Platforms for Reviews", "style": { "fontSize": 20, "color": "#F4F4F4", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 19247395, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 0, "colspan": 0, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 256955426, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "", "style": { "fontSize": "", "color": "", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 41260778, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 0, "colspan": 0, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 602739368, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "", "style": { "fontSize": "", "color": "", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 18195768, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 0, "colspan": 0, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 309928701, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "", "style": { "fontSize": "", "color": "", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": 53635405, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 0, "colspan": 0, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 966707313, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Number of Platforms for Reviews", "style": { "fontSize": 20, "color": "#F4F4F4", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 9401445, "backgroundColor": "#7400B8", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 99797353, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "916267609", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Number of Platforms for Reviews", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 16317404, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "621333159", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "4", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 94087317, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "761793642", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "4", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 42355682, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "693353963", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "1", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": 23418659, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "333336633", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "8", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 9080494, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 73356483, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "164200349", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Pre-built Template Designs", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 63894068, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "636965959", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "7+", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 91050027, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "116336324", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#FF4500", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": 53277525, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "514353626", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "3+", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": 24308654, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "373769359", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "2+", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 5725136, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 15183496, "backgroundColor": "", "columnWidth": 220, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "638913889", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Multiple Accounts", "style": { "fontSize": 15, "color": "#354886", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 71738775, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "361461012", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": 18812071, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "959521869", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": 32405513, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "163326563", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_4": { "style": { "tdId": 98037521, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "625165963", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 7898609, "backgroundColor": "", "rowHeight": "" } } ], "headers": [ "column_0", "column_1", "column_2", "column_3", "column_4" ], "table": { "tr": "10", "tc": "5", "merge": { "history": { "52277336": [ { "rowIndex": 6, "columnIndex": 0 }, { "rowIndex": 6, "columnIndex": 1 }, { "rowIndex": 6, "columnIndex": 2 }, { "rowIndex": 6, "columnIndex": 3 }, { "rowIndex": 6, "columnIndex": 4 } ] } } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": false, "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": 3, "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": 3, "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": false, "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": 700, "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 150, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "#7400B8" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#F3F4F9" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "#ffffff" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": true, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 0, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#000000" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": true, "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": true }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "#DDDDDD" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 1, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "margin_bottom": { "label": "Margin Bottom", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000001" }, "font_family": { "label": "Font Family", "type": "select", "value": "inherit", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": true } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": false }, "cell_direction": { "label": "Cell Stack Direction", "type": "select", "value": "row", "items": [ { "label": "Row", "value": "row" }, { "label": "Column", "value": "column" } ] }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": true }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "mobile_cell_border", "type": "slider", "value": 5, "min": 1, "max": 10 } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": false }, "cell_direction": { "label": "Cell Stack Direction", "type": "select", "value": "column", "items": [ { "label": "Row", "value": "row" }, { "label": "Column", "value": "column" } ] }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": true }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 2, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "tablet_cell_border", "type": "slider", "value": 5, "min": 1, "max": 10 } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false, "disable": true }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": false, "disable": true } } } } }, "responsive_settings": { "name": "Responsive Settings", "key": "responsive_settings", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "mobile_cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "mobile_table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" } }, "tablet": { "name": "Tablet", "key": "tablet", "tablet_cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "tablet_table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function comparisonTableFour()
    {
        $table_data       = '{ "id": 1040, "table_name": "Highlighted Table", "data": [ { "rows": { "column_0": { "style": { "tdId": 79351036, "backgroundColor": "", "columnWidth": 256, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10, "has_pro": true } }, "columns": [ { "id": 820929323, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Features", "style": { "fontSize": 18, "color": "rgb(254, 254, 254)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 66115901, "backgroundColor": "#11343D", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": true, "height": 14, "shadowColor": "rgb(155, 187, 238)", "offset_y": 11, "blur_radius": 17, "offset_x": 0 } }, "columns": [ { "id": 380418328, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Ninja Tables", "style": { "fontSize": 18, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 55642056, "backgroundColor": "", "columnWidth": 153, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 858081587, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "wpDataTables", "style": { "fontSize": 18, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": 64079051, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 765321964, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "TablePress", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": 32589332, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 356077007, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "WP Table Builder", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_5": { "style": { "tdId": 16075220, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 513068462, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Data Tables Generator", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 7542423, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 19452775, "backgroundColor": "", "columnWidth": 256, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 814977285, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "WooCommerce", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 11263434, "backgroundColor": "#11343D", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": true, "height": 14, "shadowColor": "rgb(155, 187, 238)", "offset_y": 11, "blur_radius": 17, "offset_x": 0 } }, "columns": [ { "id": "447800858", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": 18630605, "backgroundColor": "", "columnWidth": 153, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "449123428", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#F7632C", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": 13900588, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "616622986", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#F7632C", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_4": { "style": { "tdId": 53906999, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "364264151", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#F7632C", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_5": { "style": { "tdId": 57028148, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "615863999", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#F7632C", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 8599433, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 53334577, "backgroundColor": "", "columnWidth": 256, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 653137718, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Drag & Drop", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 70421167, "backgroundColor": "#11343D", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": true, "height": 14, "shadowColor": "rgb(155, 187, 238)", "offset_y": 11, "blur_radius": 17, "offset_x": 0 } }, "columns": [ { "id": "841116366", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": 22282198, "backgroundColor": "", "columnWidth": 153, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "634561346", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "rgb(247, 99, 44)", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": 68070206, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "643744167", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#F7632C", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_4": { "style": { "tdId": 44273410, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "661462642", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_5": { "style": { "tdId": 21900239, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "583566184", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#F7632C", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 1051403, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 72111232, "backgroundColor": "", "columnWidth": 256, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 326442964, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Conditional Formatting", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 81014889, "backgroundColor": "#11343D", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": true, "height": 14, "shadowColor": "rgb(155, 187, 238)", "offset_y": 11, "blur_radius": 17, "offset_x": 0 } }, "columns": [ { "id": "744364224", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": 59051052, "backgroundColor": "", "columnWidth": 153, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "056340449", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": 89546842, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "864104836", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#F7632C", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_4": { "style": { "tdId": 71719746, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "646919399", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#F7632C", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_5": { "style": { "tdId": 98612721, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "737574773", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 1808667, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 62408961, "backgroundColor": "", "columnWidth": 256, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 540958053, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Dynamic data types", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 10110007, "backgroundColor": "#11343D", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": true, "height": 14, "shadowColor": "rgb(155, 187, 238)", "offset_y": 11, "blur_radius": 17, "offset_x": 0 } }, "columns": [ { "id": "165442132", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": 11477064, "backgroundColor": "", "columnWidth": 153, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "634337345", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": 41606397, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "566624370", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_4": { "style": { "tdId": 33645842, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "771642399", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_5": { "style": { "tdId": 54666447, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "345717304", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 9570528, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 98212658, "backgroundColor": "", "columnWidth": 256, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 800770335, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Google Sheets Data Table", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 52294545, "backgroundColor": "#11343D", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": true, "height": 14, "shadowColor": "rgb(155, 187, 238)", "offset_y": 11, "blur_radius": 17, "offset_x": 0 } }, "columns": [ { "id": "868543351", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": 68428752, "backgroundColor": "", "columnWidth": 153, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "505643766", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": 30204434, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "733154558", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#F7632C", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_4": { "style": { "tdId": 78806364, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "424385446", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "close-circle", "style": { "color": "#F7632C", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_5": { "style": { "tdId": 88968790, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "474335615", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": true, "value": "checkmark-circle", "style": { "color": "#52CB21", "fontSize": 30, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 8187152, "backgroundColor": "", "rowHeight": 50 } } ], "headers": [ "column_0", "column_1", "column_2", "column_3", "column_4", "column_5" ], "table": { "tr": "6", "tc": "6", "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": false, "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": 3, "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": 3, "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": false, "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": 700, "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 150, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "#243345" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#1A2D3A" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "rgb(17, 61, 61)" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": true, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 0, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#000000" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": true, "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": true }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "#000000" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 1, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 31, "min": 0, "max": 100 }, "margin_bottom": { "label": "Margin Bottom", "type": "slider", "value": 61, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000001" }, "font_family": { "label": "Font Family", "type": "select", "value": "inherit", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": true } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": false }, "cell_direction": { "label": "Cell Stack Direction", "type": "select", "value": "column", "items": [ { "label": "Row", "value": "row" }, { "label": "Column", "value": "column" } ] }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "mobile_cell_border", "type": "slider", "value": 5, "min": 1, "max": 10 } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": false }, "cell_direction": { "label": "Cell Stack Direction", "type": "select", "value": "row", "items": [ { "label": "Row", "value": "row" }, { "label": "Column", "value": "column" } ] }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": true }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 2, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "tablet_cell_border", "type": "slider", "value": 3, "min": 1, "max": 10 } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false, "disable": true }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": false, "disable": true } } } } }, "responsive_settings": { "name": "Responsive Settings", "key": "responsive_settings", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "mobile_cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "mobile_table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" } }, "tablet": { "name": "Tablet", "key": "tablet", "tablet_cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "tablet_table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function comparisonTableFive()
    {

        $table_data       = '{ "id": 370, "table_name": "Comparison Table 1", "data": [ { "rows": { "column_0": { "style": { "tdId": 41812, "backgroundColor": "#348E8E", "columnWidth": 180, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 286425, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Model", "style": { "fontSize": 18, "color": "#FCFCFC", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 52190, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 457255, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Apple iPhone 10", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 26873, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 372894, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Samsung S8", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": 30726, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 593041, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Motorola Moto G5 Plus", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 4695, "backgroundColor": "#52A335", "rowHeight": 50 } }, { "style": { "trId": "408", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "6441", "backgroundColor": "#348E8E", "columnWidth": 180, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "844808", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Display", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "0468", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "680014", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "4.7 inchs Retina HD Display", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "1868", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "660684", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5.8 inchs Dual Edge Super AMOLED Display", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": "8606", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "008181", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "4.7 inchs Retina HD Display", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "364", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "6662", "backgroundColor": "#348E8E", "columnWidth": 180, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "161328", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Camera", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "6616", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "622031", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "12 MP", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "1111", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "190441", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "48 MP", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": "5125", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "699392", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "16 MP", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "869", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "6978", "backgroundColor": "#348E8E", "columnWidth": 180, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "464844", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Storage", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "6469", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "896691", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "128 GB", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "9878", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "861711", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "64 GB", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": "6484", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "788078", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "32 GB", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "808", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "8616", "backgroundColor": "#348E8E", "columnWidth": 180, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "050851", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "OS", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "4711", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "668680", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "iOS", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "8568", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "176518", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Android", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": "0046", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "071416", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Android", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "style": { "trId": "162", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "4715", "backgroundColor": "#348E8E", "columnWidth": 180, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "545872", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "External Memory Card Slot", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "1106", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "611616", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close-circle", "style": { "color": "#FF4500", "fontSize": 35, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": "6401", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "80646", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "rgb(55, 157, 19)", "fontSize": 35, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": "5452", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "221856", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "rgb(55, 157, 19)", "fontSize": 35, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "style": { "trId": "361", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "4788", "backgroundColor": "#348E8E", "columnWidth": 180, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "118778", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Rating", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": "3080", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "868646", "data": { "name": "Rating", "type": "star_rating", "icon": "el-icon-star-off", "has_pro": false, "value": 5, "style": { "color": "#B36600", "fontSize": 18, "maxStar": 5, "alignment": "center", "showRatingValue": true, "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": "4039", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "74070", "data": { "name": "Rating", "type": "star_rating", "icon": "el-icon-star-off", "has_pro": false, "value": 4.5, "style": { "color": "#B36600", "fontSize": 18, "maxStar": 5, "alignment": "center", "showRatingValue": true, "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": "6664", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "101188", "data": { "name": "Rating", "type": "star_rating", "icon": "el-icon-star-off", "has_pro": false, "value": 4, "style": { "color": "#B36600", "fontSize": 18, "maxStar": 5, "alignment": "center", "showRatingValue": true, "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "rows": { "column_0": { "style": { "tdId": 80265, "backgroundColor": "#348E8E", "columnWidth": 180, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 752618, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Price", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 45302, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 562178, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$499.99", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 80806, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 464141, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$349.99", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 76492, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 604456, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "$299.99", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 8381, "backgroundColor": "", "rowHeight": 50 } } ], "headers": [ "column_0", "column_1", "column_2", "column_3" ], "table": { "tr": 8, "tc": "4", "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": "false", "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": "3", "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": "3", "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": "false", "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": "700", "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 150, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "#dddddd" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#dddddd" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "#ffffff" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": false, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 0, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#000000" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": "true", "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": "true" }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "#000000" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 1, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000000" }, "font_family": { "label": "Font Family", "type": "select", "value": "inherit", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": "false", "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": "true" } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": "false", "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": "1", "max": "5" } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": "1", "max": "5" } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "false", "disable": "true" }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": "false", "disable": "true" } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function employeeTableOne()
    {
        $table_data       = '{ "id": 529, "table_name": "Employee Table 2", "data": [ { "rows": { "column_0": { "style": { "tdId": 10068, "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 196268, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sl ", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 10050, "backgroundColor": "", "columnWidth": 212, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "351116", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Name", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 43682, "backgroundColor": "", "columnWidth": 191, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "562682", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Email", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": 53044, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "718181", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Phone", "style": { "fontSize": 20, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": 73248, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "601638", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Joining Date", "style": { "fontSize": 20, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_6": { "style": { "tdId": "3214", "backgroundColor": "", "columnWidth": 193, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "140401", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Designation", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 4500, "backgroundColor": "", "rowHeight": 70 } }, { "rows": { "column_0": { "style": { "tdId": 64869, "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "243626", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "01", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 21709, "backgroundColor": "", "columnWidth": 212, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "748835", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Shahjahan Jewel", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 98346, "backgroundColor": "", "columnWidth": 191, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "606103", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "jewel@authlab.io", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": 95518, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "187304", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "+1-202-555-0114", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": 80753, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "526394", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5th April, 2016", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_6": { "style": { "tdId": "3060", "backgroundColor": "", "columnWidth": 193, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "409196", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Founder & Head of Ideas", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 1156, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 84174, "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "824200", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "02", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 78317, "backgroundColor": "", "columnWidth": 212, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "943088", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sheikh Heera", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 74762, "backgroundColor": "", "columnWidth": 191, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "244480", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "heera@authlab.io", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": 33199, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "281618", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "+1-202-555-0199", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": 51108, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "662663", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5th April, 2016", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_6": { "style": { "tdId": "4036", "backgroundColor": "", "columnWidth": 193, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "480000", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "CTO & Platform Architect", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 2857, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 12300, "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "508095", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "03", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 75042, "backgroundColor": "", "columnWidth": 212, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "382241", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Faizus Saleheen", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 51011, "backgroundColor": "", "columnWidth": 191, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "184806", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "faizus@authlab.io", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": 90949, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "434573", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "+1-202-555-0114", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": 82923, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "661813", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5th April, 2016", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_6": { "style": { "tdId": "4244", "backgroundColor": "", "columnWidth": 193, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "657686", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Chief Marketing Officer", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 3382, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 19875, "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "461444", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "04", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 72396, "backgroundColor": "", "columnWidth": 212, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "181684", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "MD Mahmudul Hasan", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 84559, "backgroundColor": "", "columnWidth": 191, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "069803", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "mahmudul@authlab.io", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": 48417, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "013121", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "+1-202-555-0199", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": 82021, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "535663", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5th April, 2016", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_6": { "style": { "tdId": "0265", "backgroundColor": "", "columnWidth": 193, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "845865", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Director of Engineering", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 7481, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 15610, "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 695921, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "05", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 92072, "backgroundColor": "", "columnWidth": 212, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "885343", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Zahangir Alam", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 45008, "backgroundColor": "", "columnWidth": 191, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "406622", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "zahangir@authlab.io", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": 79568, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "347463", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "+1-202-555-0199", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": 78683, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "689866", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5th April, 2016", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_6": { "style": { "tdId": "8426", "backgroundColor": "", "columnWidth": 193, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "536833", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Human Resource Manager", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 4726, "backgroundColor": "", "rowHeight": 50 } }, { "style": { "trId": "8728744", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "65688884", "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "400081460", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "06", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "12812484", "backgroundColor": "", "columnWidth": 212, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "240448885", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "MD. Kamrul Islam", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_6": { "style": { "tdId": "84802245", "backgroundColor": "", "columnWidth": 193, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "052120122", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Head of Support", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": "28014656", "backgroundColor": "", "columnWidth": 191, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "846480271", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "kamrul@authlab.io", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": "15874006", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "087454058", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "+1-202-555-0199", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": "08527858", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "882428480", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5th April, 2017", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } } }, { "style": { "trId": "8124212", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "55868865", "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "684285468", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "07", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "44554615", "backgroundColor": "", "columnWidth": 212, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "244116268", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sumon Sarker", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_6": { "style": { "tdId": "24885828", "backgroundColor": "", "columnWidth": 193, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "411104430", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Lead Sodtware Engineer", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": "88868484", "backgroundColor": "", "columnWidth": 191, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "811215818", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "csesumonpro@authlab.io", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": "84128488", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "884551515", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "+1-202-555-0199", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": "84126118", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "884615888", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "12 February, 2018", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } } }, { "style": { "trId": "8558785", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "25857187", "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "585455418", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "08", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "75856477", "backgroundColor": "", "columnWidth": 212, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "557458587", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Hasanuzzaman Shamim", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_6": { "style": { "tdId": "45555245", "backgroundColor": "", "columnWidth": 193, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "541461884", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Lead Software Engineer", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": "88185555", "backgroundColor": "", "columnWidth": 191, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "587888588", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "hasanuzzamanbe@authlab.io", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": "46541864", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "578755885", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "+1-202-555-0199", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": "48544466", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "541288554", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5th April, 2017", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } } }, { "style": { "trId": "2686872", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_0": { "style": { "tdId": "22782345", "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "844734284", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "09", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "84421876", "backgroundColor": "", "columnWidth": 212, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "214273264", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Utpol Devnath", "style": { "fontSize": 17, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_6": { "style": { "tdId": "81415388", "backgroundColor": "", "columnWidth": 193, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "721858524", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Lead Sodtware Engineer", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": "58282143", "backgroundColor": "", "columnWidth": 191, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "258258874", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "devutpol@authlab.io", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": "12445346", "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "834285321", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "+1-202-555-0199", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": "88465467", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "782468828", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "5th April, 2017", "style": { "fontSize": 15, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } } } ], "headers": [ "column_0", "column_1", "column_6", "column_2", "column_3", "column_4" ], "table": { "tr": 10, "tc": 6, "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": "false", "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": "3", "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": "3", "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": "false", "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": "700", "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 150, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "#1B5067" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#314459" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "#33404A" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": false, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 2, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#FFF200" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": true, "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": true }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 1, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000000" }, "font_family": { "label": "Font Family", "type": "select", "value": "Charcoal", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": "true" } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "mobile_cell_border", "type": "slider", "value": 1, "min": 1, "max": 10 } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 2, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "tablet_cell_border", "type": "slider", "value": 2, "min": 1, "max": 10 } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false, "disable": true }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": false, "disable": true } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function employeeTableTwo()
    {
        $table_data       = '{ "id": 520, "table_name": "Employee Table 1", "data": [ { "rows": { "column_0": { "style": { "tdId": 63979, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "011882", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Images", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 93156, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "069998", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Name", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 27104, "backgroundColor": "", "columnWidth": 175, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "198000", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Designation", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": 92183, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "212222", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Address", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": "7988", "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 716020, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Rank", "style": { "fontSize": 18, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 4521, "backgroundColor": "", "rowHeight": 60 } }, { "rows": { "column_0": { "style": { "tdId": 51256, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "35985", "data": { "name": "Image", "type": "image", "icon": "el-icon-picture-outline", "has_pro": false, "value": "http://authlab-project.test/wp-content/plugins/ninja-tables/assets/img/jewel.jpeg", "style": { "alignment": "center", "size": 50, "shape": "round", "alt": "Demo Image", "link": "https://www.example.com/", "target": "blank", "margin": { "top": 4, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_1": { "style": { "tdId": 71722, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 111698, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Shahjahan Jewel", "style": { "fontSize": 16, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 16030, "backgroundColor": "", "columnWidth": 175, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 642523, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Founder & Head of Ideas", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 67214, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 360002, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sylhet", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": "3973", "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "234228", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "01", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 4673, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 45484, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "22044", "data": { "name": "Image", "type": "image", "icon": "el-icon-picture-outline", "has_pro": false, "value": "http://authlab-project.test/wp-content/plugins/ninja-tables/assets/img/arif.jpeg", "style": { "alignment": "center", "size": 50, "shape": "round", "alt": "Demo Image", "link": "https://www.example.com/", "target": "blank", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_1": { "style": { "tdId": 42844, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 878774, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Mahmudul Hasan", "style": { "fontSize": 16, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 85451, "backgroundColor": "", "columnWidth": 175, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 108374, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Director of Engineering", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 85762, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 189365, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sylhet", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": "1173", "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "113123", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "02", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 6161, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 76007, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "06815", "data": { "name": "Image", "type": "image", "icon": "el-icon-picture-outline", "has_pro": false, "value": "http://authlab-project.test/wp-content/plugins/ninja-tables/assets/img/sumon.jpeg", "style": { "alignment": "center", "size": 50, "shape": "round", "alt": "Demo Image", "link": "https://www.example.com/", "target": "blank", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_1": { "style": { "tdId": 44725, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 226238, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sumon Sarker", "style": { "fontSize": 16, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 21658, "backgroundColor": "", "columnWidth": 175, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 511598, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Lead Software Engineer", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 25473, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 344893, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sylhet", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": "3902", "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "391290", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "03", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 3822, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 29260, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "67616", "data": { "name": "Image", "type": "image", "icon": "el-icon-picture-outline", "has_pro": false, "value": "http://authlab-project.test/wp-content/plugins/ninja-tables/assets/img/sakib.jpeg", "style": { "alignment": "center", "size": 50, "shape": "round", "alt": "Demo Image", "link": "https://www.example.com/", "target": "blank", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_1": { "style": { "tdId": 29750, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 149745, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sakib Mohammed", "style": { "fontSize": 16, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 11056, "backgroundColor": "", "columnWidth": 175, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 927095, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Software Engineer", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 18744, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 821690, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sylhet", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": "1464", "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "611013", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "04", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 5079, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 55157, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "63615", "data": { "name": "Image", "type": "image", "icon": "el-icon-picture-outline", "has_pro": false, "value": "http://authlab-project.test/wp-content/plugins/ninja-tables/assets/img/naeem.jpeg", "style": { "alignment": "center", "size": 50, "shape": "round", "alt": "Demo Image", "link": "https://www.example.com/", "target": "blank", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_1": { "style": { "tdId": 35730, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 528959, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Naeem Haque", "style": { "fontSize": 16, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 77052, "backgroundColor": "", "columnWidth": 175, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 491070, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Software Engineer", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 20949, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 714104, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sylhet", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": "4813", "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "382932", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "05", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 6526, "backgroundColor": "", "rowHeight": "" } } ], "headers": [ "column_4", "column_0", "column_1", "column_2", "column_3" ], "table": { "tr": "6", "tc": 5, "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": false, "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": 0, "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": 1, "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": "false", "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": "700", "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 150, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 856, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "#248277" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#BEE1E6" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "rgb(205, 211, 253)" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": false, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 1, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#248277" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": true, "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": "true" }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "#FF8C00" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 0, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000000" }, "font_family": { "label": "Font Family", "type": "select", "value": "Times New Roman", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": "false", "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": "true" } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": "false", "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": true }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": "1", "max": "5" } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": true }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 2, "min": "1", "max": "5" } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "false", "disable": "true" }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": "false", "disable": "true" } } } } } }';

        $table_data = $this->replaceLink('http://authlab-project.test', $table_data);

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function employeeTableThree()
    {

        $table_data       = '{ "id": 531, "table_name": "Employee-Schedule table", "data": [ { "rows": { "column_1": { "style": { "tdId": 52777, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 201632, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Name", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 27273, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "646721", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Saturday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_9": { "style": { "tdId": "0105", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "697692", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sunday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_10": { "style": { "tdId": "9999", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "896441", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Monday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_11": { "style": { "tdId": "9554", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "699998", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Tuesday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_12": { "style": { "tdId": "4080", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "469994", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Wednesday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_13": { "style": { "tdId": "0684", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "468107", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Thursday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_14": { "style": { "tdId": "6546", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "491968", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Friday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 7522, "backgroundColor": "", "rowHeight": 65 } }, { "style": { "trId": "744", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_1": { "style": { "tdId": "0044", "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "485806", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sumon Sarker", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": "6746", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "41616", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 22, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_9": { "style": { "tdId": "0688", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "682056", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 22, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_10": { "style": { "tdId": "0420", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "185109", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close-circle", "style": { "color": "rgb(255, 0, 0)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_11": { "style": { "tdId": "0684", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "959055", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 22, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_12": { "style": { "tdId": "9099", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "558584", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 22, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_13": { "style": { "tdId": "8880", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "179066", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 22, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_14": { "style": { "tdId": "5616", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "49134", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "help-circle", "style": { "color": "rgb(199, 21, 133)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "rows": { "column_1": { "style": { "tdId": 80750, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 213819, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sakib Mohammed", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 80527, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "94644", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_9": { "style": { "tdId": "0599", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "514909", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_10": { "style": { "tdId": "4929", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "188964", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_11": { "style": { "tdId": "5991", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "463140", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_12": { "style": { "tdId": "5594", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "609934", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_13": { "style": { "tdId": "8147", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "692649", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close-circle", "style": { "color": "rgb(255, 0, 0)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_14": { "style": { "tdId": "9009", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "449193", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "help-circle", "style": { "color": "#D20D89", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 9426, "backgroundColor": "", "rowHeight": 50 } }, { "style": { "trId": "691", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_1": { "style": { "tdId": "6009", "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "617666", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Naeem Haque", "style": { "fontSize": 17, "color": "rgb(0, 0, 0)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": "1060", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "044646", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_9": { "style": { "tdId": "4495", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "458266", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_10": { "style": { "tdId": "8846", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "414542", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_11": { "style": { "tdId": "5453", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "493949", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_12": { "style": { "tdId": "5449", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "490949", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_13": { "style": { "tdId": "9272", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "985071", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_14": { "style": { "tdId": "5859", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "940648", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "help-circle", "style": { "color": "#D20D89", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "rows": { "column_1": { "style": { "tdId": 11366, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "868800", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Hasanuzzaman", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 48048, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "391024", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_9": { "style": { "tdId": "5626", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "154929", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_10": { "style": { "tdId": "9241", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "021994", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_11": { "style": { "tdId": "5694", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "614119", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close-circle", "style": { "color": "rgb(255, 0, 0)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_12": { "style": { "tdId": "4999", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "945654", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_13": { "style": { "tdId": "1919", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "649978", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_14": { "style": { "tdId": "1000", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "448061", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "help-circle", "style": { "color": "#D20D89", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 9705, "backgroundColor": "", "rowHeight": 50 } }, { "style": { "trId": "560", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_1": { "style": { "tdId": "0660", "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "003899", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Utpol Devnath", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": "9000", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "904369", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_9": { "style": { "tdId": "6600", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "696741", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close-circle", "style": { "color": "rgb(255, 0, 0)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_10": { "style": { "tdId": "4911", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "254210", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_11": { "style": { "tdId": "4958", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "606544", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_12": { "style": { "tdId": "5498", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "010996", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_13": { "style": { "tdId": "9501", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "841549", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_14": { "style": { "tdId": "0509", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "086083", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "help-circle", "style": { "color": "#D20D89", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "rows": { "column_1": { "style": { "tdId": 58639, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 391438, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Ruhel Khan", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 50191, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "16436", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "help-circle", "style": { "color": "#FF0000", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_9": { "style": { "tdId": "6275", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "606956", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_10": { "style": { "tdId": "6449", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "995481", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close-circle", "style": { "color": "rgb(255, 0, 0)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_11": { "style": { "tdId": "9191", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "094491", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "rgb(55, 157, 19)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_12": { "style": { "tdId": "1649", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "090288", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close-circle", "style": { "color": "rgb(255, 0, 0)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_13": { "style": { "tdId": "0976", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "776716", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "rgb(255, 0, 0)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_14": { "style": { "tdId": "7019", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "010068", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "help-circle", "style": { "color": "#D20D89", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 8763, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_1": { "style": { "tdId": 39599, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 898305, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Bindaas Nitesh", "style": { "fontSize": 17, "color": "rgb(0, 0, 0)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 54639, "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "87818", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_9": { "style": { "tdId": "2107", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "922666", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_10": { "style": { "tdId": "5049", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "461484", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_11": { "style": { "tdId": "6441", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "116809", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_12": { "style": { "tdId": "0859", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "384469", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_13": { "style": { "tdId": "7449", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "569725", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_14": { "style": { "tdId": "9917", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "810711", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "help-circle", "style": { "color": "#D20D89", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 8871, "backgroundColor": "", "rowHeight": 50 } }, { "style": { "trId": "665", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_1": { "style": { "tdId": "9036", "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "600566", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Tanjim TC", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": "0691", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "43396", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "help-circle", "style": { "color": "rgb(255, 0, 0)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_9": { "style": { "tdId": "9571", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "654261", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_10": { "style": { "tdId": "4514", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "156224", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "checkmark-circle", "style": { "color": "#379D13", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_11": { "style": { "tdId": "6466", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "608056", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close-circle", "style": { "color": "rgb(255, 0, 0)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_12": { "style": { "tdId": "6414", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "300445", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close-circle", "style": { "color": "rgb(255, 0, 0)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_13": { "style": { "tdId": "8298", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "108979", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close-circle", "style": { "color": "rgb(255, 0, 0)", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_14": { "style": { "tdId": "7941", "backgroundColor": "", "columnWidth": 135, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "160414", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "help-circle", "style": { "color": "#D20D89", "fontSize": 20, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } } ], "headers": [ "column_1", "column_2", "column_9", "column_10", "column_11", "column_12", "column_13", "column_14" ], "table": { "tr": 9, "tc": 8, "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 7, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": false, "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": 0, "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": 0, "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": false, "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": 700, "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 160, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "rgb(83, 113, 222)" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#A9D6E5" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "#BFD2FF" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": false, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 1, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#00CED1" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": false, "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": false }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 0, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000000" }, "font_family": { "label": "Font Family", "type": "select", "value": "Palatino", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": "true" } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": true }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "mobile_cell_border", "type": "slider", "value": 1, "min": 1, "max": 10 } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 2, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "tablet_cell_border", "type": "slider", "value": 1, "min": 1, "max": 10 } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false, "disable": true }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": false, "disable": true } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function scheduleTableOne()
    {

        $table_data       = '{ "id": 533, "table_name": "Schedule Table 1", "data": [ { "rows": { "column_0": { "style": { "tdId": 55455, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "206246", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Day", "style": { "iconColor": "#000000", "iconFontSize": 25, "iconName": "calendar-outline", "iconPosition": "left", "itemSpacing": 4, "color": "#000000", "fontSize": 25, "alignment": "center", "fontWeight": [ "bold" ], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_1": { "style": { "tdId": 50573, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "184171", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Time", "style": { "iconColor": "#000000", "iconFontSize": 25, "iconName": "stopwatch-outline", "iconPosition": "left", "itemSpacing": 4, "color": "#000000", "fontSize": 25, "alignment": "center", "fontWeight": [ "bold" ], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": 29518, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "864483", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Subject", "style": { "iconColor": "#000000", "iconFontSize": 25, "iconName": "book-outline", "iconPosition": "left", "itemSpacing": 4, "color": "#000000", "fontSize": 25, "alignment": "center", "fontWeight": [ "bold" ], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_3": { "style": { "tdId": 34809, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "16710", "data": { "name": "Text Icon", "type": "text_icon", "icon": "el-icon-notebook-1", "has_pro": false, "value": "Instructor", "style": { "iconColor": "#000000", "iconFontSize": 25, "iconName": "person-circle-outline", "iconPosition": "left", "itemSpacing": 4, "color": "#000000", "fontSize": 25, "alignment": "center", "fontWeight": [ "bold" ], "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 6500, "backgroundColor": "", "rowHeight": 65 } }, { "rows": { "column_0": { "style": { "tdId": 80476, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 356626, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Saturday", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 18595, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 188012, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "10:00 AM - 11:00 AM", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 34043, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "056878", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Physics", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 77504, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 351029, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Root", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 9552, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 97213, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 936954, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sunday", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 69895, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "097460", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "10:00 AM - 11:00 AM", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 16561, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 778547, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Chemistry", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 13937, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "070780", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Root", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 8049, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 13646, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 578280, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Monday", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 70846, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "630663", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "10:00 AM - 11:00 AM", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 95451, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 567797, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Science", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 24989, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "168718", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Root", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 4412, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 79941, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 186419, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Tuesday", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 21918, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "161647", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "10:00 AM - 11:00 AM", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 45153, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 369753, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Math", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 30517, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "666884", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Root", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 8736, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 19674, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 410358, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Wednesday", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 13934, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "628801", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "10:00 AM - 11:00 AM", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 11827, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 692654, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Biology", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 90197, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "110486", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Root", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 8778, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 37518, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 116793, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Thursday", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 81295, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "586914", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "10:00 AM - 11:00 AM", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 73158, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 113579, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Geometry", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 46206, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "159519", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Root", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 9011, "backgroundColor": "", "rowHeight": "" } }, { "rows": { "column_0": { "style": { "tdId": 84035, "backgroundColor": "", "columnWidth": 170, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 459179, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Friday", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_1": { "style": { "tdId": 32645, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "400568", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "10:00 AM - 11:00 AM", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 80368, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 123660, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "English", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 96152, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "686816", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Root", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 1069, "backgroundColor": "", "rowHeight": 50 } } ], "headers": [ "column_0", "column_1", "column_2", "column_3" ], "table": { "tr": "8", "tc": "4", "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 13, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": false, "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": 1, "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": 0, "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": "false", "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": "700", "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 150, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "#37D5F5" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#D7E2FE" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "#E3E3E3" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": false, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 1, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#00CED1" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": false, "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": false }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "#C71585" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 0, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000000" }, "font_family": { "label": "Font Family", "type": "select", "value": "inherit", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": "false", "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": "true" } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": "false", "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": true }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": "1", "max": "5" } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 2, "min": "1", "max": "5" } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "false", "disable": "true" }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": "false", "disable": "true" } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function scheduleTableTwo()
    {

        $table_data       = '{ "id": 175, "table_name": "Schedule Table 2", "data": [ { "rows": { "column_1": { "style": { "tdId": 52777, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 201632, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Time", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 27273, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "646721", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Saturday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_3": { "style": { "tdId": 11764, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "873134", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sunday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_4": { "style": { "tdId": 99259, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "846373", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Monday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_5": { "style": { "tdId": 64385, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "093261", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Tuesday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_6": { "style": { "tdId": 85310, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "793630", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Wednesday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_7": { "style": { "tdId": 90315, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "439554", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Thursday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_8": { "style": { "tdId": 37921, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 849493, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Friday", "style": { "fontSize": 20, "color": "#FFFFFF", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 7522, "backgroundColor": "", "rowHeight": 70 } }, { "style": { "trId": "744", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_1": { "style": { "tdId": "0044", "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "485806", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "10:00AM - 11:30AM", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "6746", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "905606", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Physics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": "0517", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "646482", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Math", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": "4641", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "661915", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Physics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": "5109", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "464474", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Chemistry", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_6": { "style": { "tdId": "0944", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "429886", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Geometry", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_7": { "style": { "tdId": "4297", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "140649", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Statistics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": "0950", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "146008", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close", "style": { "color": "#000000", "fontSize": 15, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } } }, { "rows": { "column_1": { "style": { "tdId": 80750, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 213819, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "10:00AM - 11:30AM", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 80527, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 381302, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Physics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 47705, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 872922, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Math", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": 39019, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 657068, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Physics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": 91608, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 635595, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Chemistry", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_6": { "style": { "tdId": 75445, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 607163, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Geometry", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_7": { "style": { "tdId": 45813, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 667186, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Statistics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": 12218, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "796282", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close", "style": { "color": "#000000", "fontSize": 15, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 9426, "backgroundColor": "", "rowHeight": 50 } }, { "style": { "trId": "691", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_1": { "style": { "tdId": "6009", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "003899", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "11:40AM - 1:00PM", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "1060", "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "000060", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Math", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": "3099", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "663919", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Physics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": "9901", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "009004", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Chemistry", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": "0819", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "090019", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close", "style": { "color": "#000000", "fontSize": 15, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_6": { "style": { "tdId": "9989", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "011099", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Statistics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_7": { "style": { "tdId": "8190", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "999839", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Geometry", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": "0000", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "909091", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Economics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "rows": { "column_1": { "style": { "tdId": 11366, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 242021, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "2:00PM - 2:50PM", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 48048, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 542941, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Group Discussion", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 65772, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 134396, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Science", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": 12751, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 359831, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "English", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": 95362, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 665948, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Language", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_6": { "style": { "tdId": 52906, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 671858, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Group Discussion", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_7": { "style": { "tdId": 73538, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 643419, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Language", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": 24931, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 468610, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Group Discussion", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 9705, "backgroundColor": "", "rowHeight": 50 } }, { "style": { "trId": "560", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_1": { "style": { "tdId": "0660", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "044660", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "11:40AM - 1:00PM", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "9000", "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "440060", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Math", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": "0190", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "860468", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Physics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": "0186", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "046060", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Chemistry", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": "9084", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "066604", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close", "style": { "color": "#000000", "fontSize": 15, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_6": { "style": { "tdId": "1001", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "148810", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Statistics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_7": { "style": { "tdId": "0498", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "046068", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Geometry", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": "8800", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "496040", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Economics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } }, { "rows": { "column_1": { "style": { "tdId": 58639, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 391438, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "11:40AM - 1:00PM", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 50191, "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 957004, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Math", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 64615, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 973647, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Physics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": 69534, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 113948, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Chemistry", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": 25927, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "40173", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close", "style": { "color": "#000000", "fontSize": 15, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_6": { "style": { "tdId": 40151, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 486293, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Statistics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_7": { "style": { "tdId": 95881, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 412015, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Geometry", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": 50727, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 691973, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Economics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 8763, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_1": { "style": { "tdId": 39599, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": 898305, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "3:00PM - 4:00PM", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 54639, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "264906", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Cultural Activities", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": 30362, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "297694", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Cultural Activities", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": 77377, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "144284", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Cultural Activities", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": 23674, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "081009", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Cultural Activities", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_6": { "style": { "tdId": 47638, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "449730", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Cultural Activities", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_7": { "style": { "tdId": 76161, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "203844", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Cultural Activities", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": 97788, "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "843812", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Cultural Activities", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 8871, "backgroundColor": "", "rowHeight": 50 } }, { "style": { "trId": "665", "backgroundColor": "", "rowHeight": 50 }, "rows": { "column_1": { "style": { "tdId": "9036", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "600566", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "11:40AM - 1:00PM", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": "0691", "backgroundColor": "", "columnWidth": 160, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "664906", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Math", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_3": { "style": { "tdId": "0106", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "670675", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Physics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_4": { "style": { "tdId": "6110", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "639881", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Chemistry", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": "5604", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "608477", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "close", "style": { "color": "#000000", "fontSize": 15, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_6": { "style": { "tdId": "6300", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "567349", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Statistics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_7": { "style": { "tdId": "9570", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "068660", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Geometry", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": "9183", "backgroundColor": "", "columnWidth": "", "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1 }, "columns": [ { "id": "000486", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Economics", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } } } ], "headers": [ "column_1", "column_2", "column_3", "column_4", "column_5", "column_6", "column_7", "column_8" ], "table": { "tr": 9, "tc": 8, "merge": { "history": [] } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 10, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": "false", "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": "3", "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": "3", "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": false, "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": 700, "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 160, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 500, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "rgb(180, 19, 119)" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#D3F8DA" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "#E9ECFF" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": false, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 1, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#8A36E0" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": false, "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": false }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 0, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000000" }, "font_family": { "label": "Font Family", "type": "select", "value": "Georgia", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": "false", "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": "true" } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": "false", "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": "1", "max": "5" } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 2, "min": "1", "max": "5" } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "false", "disable": "true" }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": "false", "disable": "true" } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function scheduleTableThree()
    {
        $table_data       = '{ "id": 741, "table_name": "Schedule Table 3", "data": [ { "rows": { "column_0": { "style": { "tdId": 30012, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 335994, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Day", "style": { "fontSize": 25, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 88024, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "006663", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "10:00AM - 11:50AM", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_2": { "style": { "tdId": 84351, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 361007, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "12:00PM - 1:00PM", "style": { "fontSize": 15, "color": "rgb(254, 254, 254)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_5": { "style": { "tdId": 91563, "backgroundColor": "#AECBEF", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 8, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "448640", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "Lunch Break", "style": { "fontSize": 16, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold", "italic" ] } } } ] }, "column_6": { "style": { "tdId": 32313, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "234561", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "2:00PM - 2:50PM", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_8": { "style": { "tdId": "4424", "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "976477", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "3:00PM - 3:50PM", "style": { "fontSize": 15, "color": "rgb(255, 255, 255)", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] } }, "style": { "trId": 3494, "backgroundColor": "", "rowHeight": 75 } }, { "rows": { "column_0": { "style": { "tdId": 44339, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 301301, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Saturday", "style": { "fontSize": 20, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 40892, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 245699, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Math", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 98915, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "910114", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Science", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": 32025, "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 0, "colspan": 0, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 536375, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Add New", "style": { "fontSize": "", "color": "", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_6": { "style": { "tdId": 69807, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "474786", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Statistics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": "0411", "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "612162", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "Economics", "style": { "fontSize": 17, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 1080, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 93338, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 122545, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Sunday", "style": { "fontSize": 20, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 49996, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 534244, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Physics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 78158, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 150503, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Science", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": 26241, "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 0, "colspan": 0, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 200910, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Add New", "style": { "fontSize": "", "color": "", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_6": { "style": { "tdId": 43393, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 848121, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Economics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": "0680", "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "968968", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "Statistics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 9890, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 82565, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 308539, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Monday", "style": { "fontSize": 20, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 62291, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 487833, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Math", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 20089, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 117122, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Physics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": 20809, "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 0, "colspan": 0, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 878533, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Add New", "style": { "fontSize": "", "color": "", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_6": { "style": { "tdId": 85917, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 159476, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Economics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": "9604", "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 598928, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Science", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] } }, "style": { "trId": 2141, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 18234, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 987396, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Tuesday", "style": { "fontSize": 20, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 13451, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 226030, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Chemistry", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 60417, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "688059", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Statistics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": 56043, "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 0, "colspan": 0, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 842615, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Add New", "style": { "fontSize": "", "color": "", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_6": { "style": { "tdId": 55614, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 550455, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Science", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": "4542", "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "241102", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "Economics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 8940, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 65865, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 991869, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Wednesday", "style": { "fontSize": 20, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 20080, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 712794, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Statistics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 86048, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 743716, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Economics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": 16210, "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 0, "colspan": 0, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 573013, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Add New", "style": { "fontSize": "", "color": "", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_6": { "style": { "tdId": 99502, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 759148, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Physics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": "6866", "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "961616", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "Chemistry", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 7538, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": 71059, "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "862263", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Thursday", "style": { "fontSize": 20, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": 67608, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 910496, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Science", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_2": { "style": { "tdId": 95859, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "315146", "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Economics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_5": { "style": { "tdId": 23206, "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 0, "colspan": 0, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 977155, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Add New", "style": { "fontSize": "", "color": "", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_6": { "style": { "tdId": 21567, "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 970098, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Biology", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [] } } } ] }, "column_8": { "style": { "tdId": "4600", "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "584914", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "Accounting", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": 6651, "backgroundColor": "", "rowHeight": 50 } }, { "rows": { "column_0": { "style": { "tdId": "4469", "backgroundColor": "", "columnWidth": 165, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": 783083, "data": { "name": "Text", "type": "text", "icon": "el-icon-edit-outline", "has_pro": false, "value": "Friday", "style": { "fontSize": 20, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "fontWeight": [ "bold" ] } } } ] }, "column_1": { "style": { "tdId": "2116", "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "284804", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "Statistics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_2": { "style": { "tdId": "6446", "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "660204", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "Physics", "style": { "fontSize": 18, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_5": { "style": { "tdId": "6189", "backgroundColor": "", "columnWidth": 100, "emptyCell": "", "verticalAlignment": "", "rowspan": 0, "colspan": 0, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "448640", "data": { "has_pro": false, "icon": "el-icon-edit-outline", "name": "Text", "type": "text", "value": "Add New", "style": { "fontSize": 15, "color": "#000000", "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_6": { "style": { "tdId": "4874", "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "474792124", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "remove", "style": { "color": "#000000", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] }, "column_8": { "style": { "tdId": "8194", "backgroundColor": "", "columnWidth": 150, "emptyCell": "", "verticalAlignment": "", "rowspan": 1, "colspan": 1, "highlighted": { "active": false, "height": 10, "shadowColor": "#888", "offset_y": 10, "blur_radius": 10 } }, "columns": [ { "id": "146018", "data": { "name": "Icon", "type": "icon", "icon": "el-icon-finished", "has_pro": false, "value": "remove", "style": { "color": "#000000", "fontSize": 25, "alignment": "center", "margin": { "top": 0, "bottom": 0, "left": 0, "right": 0 }, "padding": { "top": 0, "bottom": 0, "left": 0, "right": 0 } } } } ] } }, "style": { "trId": "008", "backgroundColor": "", "rowHeight": 50 } } ], "headers": [ "column_0", "column_1", "column_2", "column_5", "column_6", "column_8" ], "table": { "tr": 8, "tc": 6, "merge": { "history": { "57381": [ { "rowIndex": 0, "columnIndex": 4, "headerIndex": "4" }, { "rowIndex": 1, "columnIndex": 4, "headerIndex": "4" }, { "rowIndex": 2, "columnIndex": 4, "headerIndex": "4" }, { "rowIndex": 3, "columnIndex": 4, "headerIndex": "4" }, { "rowIndex": 4, "columnIndex": 4, "headerIndex": "4" }, { "rowIndex": 5, "columnIndex": 4, "headerIndex": "4" }, { "rowIndex": 6, "columnIndex": 4, "headerIndex": "4" } ], "91563": [ { "rowIndex": 1, "columnIndex": 4, "headerIndex": "5" }, { "rowIndex": 0, "columnIndex": 4, "headerIndex": "5" }, { "rowIndex": 2, "columnIndex": 4, "headerIndex": "5" }, { "rowIndex": 3, "columnIndex": 4, "headerIndex": "5" }, { "rowIndex": 4, "columnIndex": 4, "headerIndex": "5" }, { "rowIndex": 5, "columnIndex": 4, "headerIndex": "5" }, { "rowIndex": 6, "columnIndex": 4, "headerIndex": "5" }, { "rowIndex": 7, "columnIndex": 4, "headerIndex": "5" } ] } } } }';
        $table_settings   = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "cell_padding": { "label": "Cell Padding", "type": "slider", "value": 14, "min": 0, "max": 50 }, "table_alignment": { "label": "Table Alignment", "type": "alignment", "value": "center" }, "columns_rows_separate": { "label": "Separate Columns/Rows", "type": "switch", "value": "false", "childs": { "space_between_column": { "label": "Space Between Columns", "type": "slider", "value": "3", "min": 0, "max": 50 }, "space_between_row": { "label": "Space Between Rows", "type": "slider", "value": "3", "min": 0, "max": 50 } } }, "container_max_width_switch": { "label": "Table Container Max Width", "type": "switch", "value": true, "childs": { "container_max_width": { "label": "Table Container Max Width", "type": "slider", "value": 1263, "min": 100, "max": 5000 } } }, "cell_min_auto_width": { "label": "Table Cell Min Auto Width", "type": "slider", "value": 95, "min": 10, "max": 500 }, "container_max_height": { "label": "Table Container Max Height", "type": "slider", "value": 1003, "min": 100, "max": 2000 } } }, "background": { "name": "Background", "key": "background", "has_pro": false, "options": { "header_background": { "label": "Header Background", "type": "color", "value": "#9372FF" }, "even_row_background": { "label": "Even Row Background", "type": "color", "value": "#D1FFD1" }, "odd_row_background": { "label": "Odd Row Background", "type": "color", "value": "#D4E7FF" } } }, "sticky": { "name": "Sticky", "key": "sticky", "has_pro": true, "options": { "first_row_sticky": { "label": "First Row Sticky", "type": "switch", "value": false }, "first_column_sticky": { "label": "First Column Sticky", "type": "switch", "value": false } } }, "accessibility": { "name": "Accessibility", "key": "accessibility", "has_pro": false, "options": { "table_role": { "label": "Table Role", "type": "select", "value": "table", "items": [ { "label": "Table", "value": "table" }, { "label": "Presentation", "value": "presentation" }, { "label": "List", "value": "list" }, { "label": "Row Group", "value": "rowgroup" } ] } } }, "border": { "name": "Border", "key": "border", "has_pro": false, "options": { "table_border": { "label": "Table Border", "type": "slider", "value": 1, "min": 0, "max": 50 }, "border_color": { "label": "Border Color", "type": "color", "value": "#4F18E7" }, "inner_border": { "label": "Apply Inner Border", "type": "switch", "value": true, "childs": { "header_inner_border": { "label": "Header Inner Border", "type": "switch", "value": "true" }, "inner_border_color": { "label": "Inner Border Color", "type": "color", "value": "#4F18E7" }, "inner_border_size": { "label": "Inner Border Size", "type": "slider", "value": 1, "min": 0, "max": 50 } } } } }, "global_styling": { "name": "Global Style", "key": "global_styling", "has_pro": false, "options": { "margin_top": { "label": "Margin Top", "type": "slider", "value": 0, "min": 0, "max": 100 }, "font_size": { "label": "Font Size", "type": "slider", "value": 15, "min": 12, "max": 40 }, "color": { "label": "Color", "type": "color", "value": "#000000" }, "font_family": { "label": "Font Family", "type": "select", "value": "Times New Roman", "items": [ { "label": "Inherit", "value": "inherit" }, { "label": "Arial", "value": "Arial" }, { "label": "Helvetica", "value": "Helvetica" }, { "label": "Comic Sans", "value": "Comic Sans" }, { "label": "Courier New", "value": "Courier New" }, { "label": "Georgia", "value": "Georgia" }, { "label": "Impact", "value": "Impact" }, { "label": "Charcoal", "value": "Charcoal" }, { "label": "Lucida Grande", "value": "Lucida Grande" }, { "label": "Palatino Linotype", "value": "Palatino Linotype" }, { "label": "Book Antiqua", "value": "Book Antiqua" }, { "label": "Palatino", "value": "Palatino" }, { "label": "Tahoma", "value": "Tahoma" }, { "label": "Geneva", "value": "Geneva" }, { "label": "Times New Roman", "value": "Times New Roman" }, { "label": "Verdana", "value": "Verdana" }, { "label": "Monaco", "value": "Monaco" } ] } } } }';
        $table_responsive = '{ "general": { "name": "General", "key": "general", "has_pro": false, "options": { "enable_responsive_table": { "label": "Enable Responsive Table", "type": "switch", "value": "true" } } }, "mode_options": { "name": "Mode Options", "key": "mode_options", "has_pro": false, "options": { "devices": { "mobile": { "name": "Mobile", "key": "mobile", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": true }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 1, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "mobile_cell_border", "type": "slider", "value": 3, "min": 1, "max": 10 } }, "tablet": { "name": "Tablet", "key": "tablet", "disable_breakpoint": { "label": "Disable Breakpoint", "key": "disable_breakpoint", "type": "switch", "value": "false" }, "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": "true" }, "items_per_row": { "label": "Items Per Header", "key": "items_per_header", "type": "slider", "value": 2, "min": 1, "max": 5 }, "cell_border": { "label": "Group Separator", "key": "tablet_cell_border", "type": "slider", "value": 3, "min": 1, "max": 10 } }, "desktop": { "name": "Desktop", "key": "desktop", "top_row_as_header": { "label": "Top Row As Header", "key": "top_row_as_header", "type": "switch", "value": false, "disable": true }, "static_top_row": { "label": "Static Top Row", "key": "static_top_row", "type": "switch", "value": false, "disable": true } } } } } }';

        return [
            'table_data'       => json_decode($table_data, true),
            'table_settings'   => json_decode($table_settings, true),
            'table_responsive' => json_decode($table_responsive, true)
        ];
    }

    public function replaceLink($replacedUrl, $data)
    {
        return str_replace($replacedUrl, site_url(), $data);
    }
}
